
IF EXISTS (SELECT *FROM SYS.OBJECTS WHERE NAME = 'UFD_BUSCA_COD_BENEFICIO')

BEGIN 
      DROP FUNCTION  UFD_BUSCA_COD_BENEFICIO
END ;
GO

/*
  OBJETIVO      : FUNÇÃO CRIADA PARA RETORNAR O CÓDIGO DO BENEFÍCIO FISCAL DO PRODUTO BASEADO NOS DADOS DA TRIBUTAÇÃO (CST), UF E MOVIMENTAÇÃO
			      PARA AUXILIAR NA ALTERAÇÃO DA CARGA DOS PRODUTOS DA EST_PROD_CPL
  CRIADA POR    : FERNANDO JUNIO CUNHA E SOUSA
  EMPRESA		: LINX
  DT CRIAÇÃO    : 27/12/2019
  ULT ALTERAÇÃO : 28/12/2019
  PARÂMETROS    : @CD_EMP     - CÓDIGO DA EMPRESA
				  @CD_PROD    - CÓDIGO DO PRODUTO
				  @CD_TRIB_FC - CÓDIGO DO CST DO PRODUTO ('040','060','120',ECT.)
				  @TP_MOV     - TIPO DA MOVIMENTAÇÃO DO PRODUTO (0 - VENDA AO CONSUMIDOR FINAL, ETC..)
  PARA TESTAR   : SELECT UFD_BUSCA_COD_BENEFICIO (1, 43063, 3, 'PR', 0)
*/ 



	-- SELECT * from UFD_BUSCA_COD_BENEFICIO (1, 107721, 3, 'PR', 0)
CREATE FUNCTION UFD_BUSCA_COD_BENEFICIO (@CD_EMP   INT, 
                                         @CD_PROD  INT, 
									     @CD_TRIB_FC VARCHAR(3), 
									     @UF       VARCHAR(2), 
									     @TP_MOV   INT = 0)

RETURNS @CODIGO_BENEFICIO_FISCAL TABLE (CODIGO_BENEFICIO_FISCAL VARCHAR(10))
AS
	BEGIN
	 

		DECLARE @RS_DADOS_BENEFICIO TABLE  
		(
			CD_PROD INT,
			CD_BENEF VARCHAR(10),
			TP_MOV INT,
			UF VARCHAR(2),
			CD_TRIB_FC INT
		);


		INSERT INTO @RS_DADOS_BENEFICIO
		SELECT
			  M.CD_PROD,
			  M.CD_BENEF,
			  M.TP_MOV,
			  M.UF,
			  M.CD_TRIB_FC
	  	 FROM EST_PROD_COD_BENEF_TP_MOV M
		WHERE M.CD_PROD = @CD_PROD 
		  AND M.TP_MOV  = @TP_MOV 
		  AND M.UF      = @UF 
		  AND M.CD_EMP  = @CD_EMP 
		  AND ROUND(M.CD_TRIB_FC,2) = ROUND(@CD_TRIB_FC,2)

		IF ( 1 <> (SELECT COUNT(1) FROM @RS_DADOS_BENEFICIO))
		    BEGIN
		    	INSERT INTO @RS_DADOS_BENEFICIO (CD_PROD, CD_BENEF, UF)
		    	SELECT
		    	      M.CD_PROD,
		    	      M.CD_BENEF,
		    	      M.UF
		    	 FROM EST_PROD_COD_BENEF M
		    	WHERE M.CD_PROD = @CD_PROD 
				  AND M.UF      = @UF 
				  AND M.CD_EMP  = @CD_EMP
		    END;
	 
		 INSERT INTO @CODIGO_BENEFICIO_FISCAL 
		 SELECT TOP 1 CD_BENEF 
		   FROM @RS_DADOS_BENEFICIO 
		
		RETURN 
	END;
GO




